<?php 
require_once('tcpdf/tcpdf.php');
require_once('conexiones/conexion.php');

// Obtener los datos del ticket (se debe pasar el código del ticket por GET)
$codigo_ticket = $_GET['codigo_ticket'] ?? '';

// Consultar los datos del ticket desde la base de datos
$stmt = $pdo->prepare("SELECT * FROM tickets WHERE codigo_ticket = ?");
$stmt->execute([$codigo_ticket]);
$ticket = $stmt->fetch(PDO::FETCH_ASSOC);

if ($ticket) {
    // Datos del ticket
    $cliente_nombre = $ticket['cliente_nombre'];
    $tipo_ticket = $ticket['tipo_ticket'];
    $validez_ticket = $ticket['validez_ticket'];
    $precio = $ticket['precio'];
    $codigo_ticket = $ticket['codigo_ticket'];

    // Consultar los datos de la empresa desde la base de datos (o configuración)
    $stmt = $pdo->prepare("SELECT empresa_nombre, razon_social, email_contacto, direccion, moneda FROM configuracion");
    $stmt->execute();
    $empresa = $stmt->fetch(PDO::FETCH_ASSOC);

    // Crear el PDF
    $pdf = new TCPDF('P', 'mm', array(80, 200)); // Ancho fijo de 80 mm y alto ajustable
    $pdf->SetAutoPageBreak(TRUE, 15);
    $pdf->AddPage();

    // Título del recibo
    $pdf->SetFont('helvetica', 'B', 16);
    $pdf->Write(0, "Comprobante de Ticket", '', 0, 'C', true, 0, false, false, 0);

    // Información de la empresa
    $pdf->SetFont('helvetica', '', 10);
    $pdf->Ln(10);
    $pdf->Write(0, "Empresa: " . $empresa['empresa_nombre'], '', 0, 'L', true, 0, false, false, 0);
    $pdf->Write(0, "Razón Social: " . $empresa['razon_social'], '', 0, 'L', true, 0, false, false, 0);
    $pdf->Write(0, "Correo: " . $empresa['email_contacto'], '', 0, 'L', true, 0, false, false, 0);
    $pdf->Write(0, "Dirección: " . $empresa['direccion'], '', 0, 'L', true, 0, false, false, 0);
    $pdf->Write(0, "Moneda: " . $empresa['moneda'], '', 0, 'L', true, 0, false, false, 0);

    $pdf->Ln(10);
    $pdf->Write(0, "Nombre Cliente: " . $cliente_nombre, '', 0, 'L', true, 0, false, false, 0);
    $pdf->Write(0, "Tipo de Ticket: " . $tipo_ticket, '', 0, 'L', true, 0, false, false, 0);
    $pdf->Write(0, "Validez: " . $validez_ticket, '', 0, 'L', true, 0, false, false, 0);
    $pdf->Write(0, "Precio: " . $precio, '', 0, 'L', true, 0, false, false, 0);
    $pdf->Write(0, "Código Ticket: " . $codigo_ticket, '', 0, 'L', true, 0, false, false, 0);

    // Calcular la altura total del contenido
    $altura_contenido = $pdf->GetY(); // Obtener la altura actual después del contenido

    // Ajustar la posición para el QR
    $pdf->SetY($altura_contenido + 7); // Colocar el QR después del contenido con un margen de 10 mm

    // Código QR (si tienes el archivo del QR)
    $qr_code_file = 'qrs/' . $codigo_ticket . '.png';
    if (file_exists($qr_code_file)) {
        $pdf->Image($qr_code_file, 15, $pdf->GetY(), 40, 40);
    }

    // Salida del PDF
    $pdf->Output('ticket_' . $codigo_ticket . '.pdf', 'I');
} else {
    echo "Ticket no encontrado.";
}
 ?>